// config/db.js
import mongoose from 'mongoose';

const connectDb = async () => {
  try {
    await mongoose.connect(process.env.MONGODB_URI);
    console.log('MongoDB is connected..!');
  } catch (err) {
    console.error('Error inside DB connection:', err);
    process.exit(1);
  }
};

export default connectDb;
