const jwt = require("jsonwebtoken");

function CreateToken(user) {
    let token = jwt.sign( 
        {
            userId: user._id.toString(),
            organisation: "heddge capitals",
        }

    )
    return token;

}

const generateAuthToken = ({userId,email}) => {
    try {
        const token = jwt.sign({
            userId,email
        },
        process.env.SECRET_KEY,
        {
            expiresIn: "1h"
        }
    
    )
    return token;
    } catch (error) {
        console.log("Error in generating auth token",error);
        throw error;
    }
}





module.exports = { generateAuthToken,CreateToken };