// controllers/AdminController.js

import Admin from '../models/AdminModel.js';
import User from '../models/User.js';
import jwt from 'jsonwebtoken';

// Create a new admin (for testing/demo only)
export const createAdmin = async (req, res) => {
  try {
    const obj = {
      name: "Raj",
      number: "12345678",
      email: "user@gmail.com",
      password: "user@123", // In production, hash this!
      adminType: "Admin",
    };

    const existing = await Admin.findOne({ email: obj.email });
    if (existing) {
      return res.status(409).json({ message: "Admin already exists with this email" });
    }

    await Admin.create(obj);
    res.json({ message: "Admin created successfully" });
  } catch (error) {
    console.error("Admin creation failed:", error);
    res.status(500).json({ error: "Server error during admin creation" });
  }
};

// Admin login
export const loginAdmin = async (req, res) => {
  console.log(req.body);
  try {
    const { email, password } = req.body;
    console.log(email, password);
    // Validate input
    if (!email || !password) {
      return res.status(400).json({ success: 0, message: "Missing required fields" });
    }

    const admin = await Admin.findOne({ email });

    if (!admin) {
      return res.status(401).json({ message: "Invalid admin email" });
    }

    // Simple password check (use bcrypt in production!)
    if (admin.password !== password) {
      return res.status(401).json({ message: "Invalid admin password" });
    }

    const token = jwt.sign(
      {
        id: admin._id,
        email: admin.email,
        role: admin.adminType || "Admin",
      },
      process.env.JWT_SECRET,
      { expiresIn: "1d" }
    );

    res.json({ success: 1, token });
  } catch (error) {
    console.error(" loginAdmin error:", error);
    res.status(500).json({ message: "Server error", error: error.message });
  }
};

// Admin activates a user
export const activateUser = async (req, res) => {
  try {
    const updatedUser = await User.findByIdAndUpdate(
      req.params.id,
      { isActive: true },
      { new: true }
    );

    if (!updatedUser) {
      return res.status(404).json({ message: "User not found" });
    }

    res.json({ message: "User activated", user: updatedUser });
  } catch (error) {
    console.error("Activation failed:", error);
    res.status(400).json({ error: "Activation failed" });
  }
};

export const logoutAdmin = async (req, res) => {
  try {
    // Client should just delete token on their side
    res.json({ success: 1, message: "Logged out successfully" });
  } catch (error) {
    console.error("logoutAdmin error:", error);
    res.status(500).json({ message: "Server error", error: error.message });
  }
};
