// controllers/ManagerController.js
import ManagerModel from '../models/ManagerModel.js';

export const createManager = async (req, res) => {
  const {
    managerName,
    managerPassword,
    managerAccess
  } = req.body;

  // ✅ Validate required fields
  if (!managerName || !managerPassword || !managerAccess) {
    return res.status(400).json({ success: 0, msg: 'Missing required fields' });
  }

  try {
    const manager = await ManagerModel.create(req.body);
    console.log("✅ Manager created:", manager);
    res.status(201).json({ message: 'Manager created successfully', manager });
  } catch (error) {
    console.error("❌ Error creating manager:", error.message);
    res.status(500).json({ error: 'Manager creation failed' });
  }
};
