import { FixGenerator } from '../services/fixGenerator.js';
import { FixParser } from '../services/fixParser.js';
import { initialize, broadcastMarketData } from '../services/websocketService.js';

const subscriptions = new Map();

export class MarketDataController {
  static handleMarketDataRequest(fixMessage) {
    const fields = FixParser.parse(fixMessage);

    const mdReqId = fields['262'];
    const symbol = fields['55'];
    const subscriptionType = fields['263']; // 1 = Sub, 2 = Unsub
    const streamId = fields['7533'] || 'default_stream';

    if (!symbol) {
      return FixGenerator.generate('Y', `262=${mdReqId}|58=Symbol required|`);
    }

    if (subscriptionType === '1') {
      // Save the subscription
      subscriptions.set(mdReqId, { symbol, streamId });

      // Snapshot data (example)
      const snapshotData = [
        { type: '0', price: '1.2000', size: '1000000', entryId: 'E1' },
        { type: '1', price: '1.2005', size: '1000000', entryId: 'E2' }
      ];

      // Optionally broadcast to WebSocket clients
      broadcastMarketData(symbol, snapshotData);

      // Generate FIX Market Data Full Refresh (MsgType = W)
      const fixBody = 
        `7533=${streamId}|262=${mdReqId}|55=${symbol}|268=${snapshotData.length}|` +
        snapshotData.map(entry => 
          `269=${entry.type}|270=${entry.price}|271=${entry.size}|299=${entry.entryId}|`
        ).join('');

      return FixGenerator.generate('W', fixBody);
    }

    if (subscriptionType === '2') {
      subscriptions.delete(mdReqId);
      return FixGenerator.generate('W', `262=${mdReqId}|55=${symbol}|268=0|`);
    }

    return FixGenerator.generate('Y', `262=${mdReqId}|58=Invalid subscription type|`);
  }
}
