import { FixGenerator } from '../services/fixGenerator.js';
import { FixParser } from '../services/fixParser.js';
const positions = new Map();
const accountBalances = new Map();

export class PositionController {
  static handlePositionRequest(fixMessage) {
    const fields = FixParser.parse(fixMessage);
    const posReqId = fields['710'];
    const account = fields['1'];
    
    if (!account) {
      return FixGenerator.generate('AP', 
        `710=${posReqId}|728=1|58=Account required|`
      );
    }

    // Initialize account if not exists
    if (!accountBalances.has(account)) {
      accountBalances.set(account, {
        balance: '100000',
        equity: '100000',
        marginUsed: '0',
        marginLimit: '500000'
      });
    }

    const positionReport = `710=${posReqId}|1=${account}|721=${account}_${Date.now()}|` +
      `5001=100000|5002=100000|5003=0|5004=0|5005=500000|268=0|`;
    
    return FixGenerator.generate('AP', positionReport);
  }
}