// app.js
import dotenv from 'dotenv';
dotenv.config();
import http from 'http';
import express from 'express';
import mongoose from 'mongoose';
import cors from 'cors';

import authRoutes from './routes/authRoutes.js';
import adminRoutes from './routes/AdminRoutes.js';
import managerRoutes from './routes/ManagerRoutes.js';
import connectDb from './config/db.js';
//
import { WebSocketServer } from 'ws';
import { initialize as initializeWebSocket } from './services/websocketService.js';
import { sessionRoutes } from './routes/sessionRoutes.js';
import { marketDataRoutes }  from './routes/marketDataRoutes.js';
import { tradingRoutes } from './routes/tradingRoutes.js';
import { positionRoutes } from './routes/positionRoutes.js';

const app = express();
const server = http.createServer(app);

app.use(express.json());
app.use(cors());

// Connect to MongoDB
connectDb();

const wss = new WebSocketServer({ server });
initializeWebSocket(wss);

// Routes For Trading App
app.use('/session', sessionRoutes);
app.use('/marketdata', marketDataRoutes);
app.use('/trading', tradingRoutes);
app.use('/positions', positionRoutes);
// Define routes
app.use('/', authRoutes);
app.use('/', adminRoutes);
app.use('/', managerRoutes);
//
// Start server
const PORT = process.env.PORT || 5000;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
