import mongoose from 'mongoose';

const userSchema = new mongoose.Schema({
  firstname: { type: String, required: true },
  lastname: { type: String, required: true },
  email: { type: String, required: true, unique: true },
  phone: { type: String, required: true },
  leverage: {
    type: String,
    enum: ["1:100", "1:200", "1:300", "1:400"],
    required: true,
  },
  deposit: {
    type: String,
    enum: ["5000USD", "1000USD", "5500USD", "7500USD"],
    required: true,
  },
  isActivated: { type: Boolean, default: false },
  password: { type: String },
});

// module.exports = mongoose.model("User", userSchema);

const User = mongoose.model('User', userSchema);
export default User; 