import express from 'express';
import { TradingController } from '../controllers/tradingController.js';
import { FixParser } from '../services/fixParser.js';

const router = express.Router();

router.post('/order', (req, res) => {
      const jsonBody = req.body;
  const fixMessage = Object.entries(jsonBody)
    .map(([tag, value]) => `${tag}=${value}`)
    .join('\x01') + '\x01';
  const clientId = FixParser.extractClientId(fixMessage);
  const response = TradingController.handleNewOrderSingle(fixMessage, clientId);
  res.send(response);
});

router.post('/cancel', (req, res) => {
      const jsonBody = req.body;
  const fixMessage = Object.entries(jsonBody)
    .map(([tag, value]) => `${tag}=${value}`)
    .join('\x01') + '\x01';
  const response = TradingController.handleOrderCancelRequest(fixMessage);
  res.send(response);
});

export { router as tradingRoutes };