// models/ManagerModel.js
import mongoose from 'mongoose';

const permissionSetSchema = new mongoose.Schema({
  permissions: {
    ChangeLeverag: Boolean,
    EditTrades: Boolean,
    ChangeGroup: Boolean,
    DeleteTrades: Boolean,
  },
  role: {
    type: String,
    enum: ['No Rights', 'Admin Role', 'Manager Role', 'Full Access Role'],
  }
});

const managerSchema = new mongoose.Schema({
  managerName: { type: String, required: true },
  managerPassword: { type: String, required: true },
  managerAccess: [permissionSetSchema]
});

const Manager = mongoose.model('Manager', managerSchema);

export default Manager;
