export class FixGenerator {
  static generate(messageType, body) {
    const header = this._generateHeader(messageType);
    const trailer = this._generateTrailer();
    
    let message = `${header}${body}${trailer}`;
    message = message.replace(/\|/g, '\x01'); // Replace temporary delimiters
    
    const checksum = this._calculateChecksum(message);
    return `${message}10=${checksum}\x01`;
  }

  static _generateHeader(messageType) {
    return `8=FIX.4.4\x019=${this._calculateBodyLength(messageType)}\x0135=${messageType}\x01` +
      `49=${process.env.SENDER_COMP_ID || 'SERVER'}\x01` +
      `56=${process.env.TARGET_COMP_ID || 'CLIENT'}\x01` +
      `34=${this._getNextSeqNum()}\x01` +
      `52=${new Date().toISOString()}\x01`;
  }

  static _generateTrailer() {
    return '';
  }

  static _calculateBodyLength(messageType) {
    return messageType.length.toString().padStart(3, '0');
  }

  static _calculateChecksum(message) {
    let sum = 0;
    for (let i = 0; i < message.length; i++) {
      sum += message.charCodeAt(i);
    }
    return (sum % 256).toString().padStart(3, '0');
  }

  static _getNextSeqNum() {
    return Math.floor(Math.random() * 1000) + 1;
  }
}