export class FixParser {
  static parse(fixMessage) {
    const fields = {};
    const parts = fixMessage.split('\x01');
    
    parts.forEach(part => {
      if (part) {
        const [tag, value] = part.split('=');
        if (tag && value) {
          fields[tag] = value;
        }
      }
    });
    
    return fields;
  }

  static getMessageType(fixMessage) {
    const msgTypeTag = fixMessage.match(/35=([^\x01]+)/);
    return msgTypeTag ? msgTypeTag[1] : null;
  }

  static extractClientId(fixMessage) {
    const senderCompId = fixMessage.match(/49=([^\x01]+)/);
    return senderCompId ? senderCompId[1] : null;
  }
}