import FIXParser from 'fixparser'; 
import dotenv from 'dotenv';
dotenv.config();

const fixParser = new FIXParser();
const fixClient = fixParser.createClient(); // ✅ Available in v7.2.1

export const connectFixSession = async () => {
  return new Promise((resolve, reject) => {
    fixClient.connect({
      host: process.env.SOCKET_CONNECT_HOST,
      port: parseInt(process.env.SOCKET_CONNECT_PORT),
      sender: process.env.SENDER_COMP_ID,
      target: process.env.TARGET_COMP_ID,
      heartbeatIntervalSeconds: 30,
      fixVersion: process.env.BEGIN_STRING,
      tls: process.env.SOCKET_USE_SSL === 'Y',
    });

    fixClient.on('open', () => {
      console.log('📡 FIX connection established.');
      fixClient.logon({
        username: process.env.LOGIN_USERNAME,
        password: process.env.LOGIN_PASSWORD,
        resetSeqNumFlag: process.env.RESET_ON_LOGON,
      });
    });

    fixClient.on('logon', () => {
      console.log('✅ Logon successful!');
      resolve(fixClient);
    });

    fixClient.on('error', (err) => {
      console.error('❌ FIX Connection Error:', err);
      reject(err);
    });

    fixClient.on('message', (message) => {
      console.log('📥 FIX Message:', message.encode());
    });
  });
};
