import { FixGenerator } from './fixGenerator.js';

const clients = new Set();

export function initialize(wss) {
  wss.on('connection', (ws) => {
    clients.add(ws);
    console.log('New WebSocket connection');
    
    ws.id = `CLIENT_${Date.now()}`;
    
    ws.on('message', (message) => {
      console.log(`Received from ${ws.id}:`, message.toString());
    });
    
    ws.on('close', () => {
      clients.delete(ws);
      console.log(`WebSocket connection ${ws.id} closed`);
    });
    
    ws.on('error', (error) => {
      console.error(`WebSocket error (${ws.id}):`, error);
    });
  });
}

export function broadcastMarketData(symbol, data) {
  const fixMessage = FixGenerator.generate('W', 
    `55=${symbol}|262=WS_${Date.now()}|268=${data.length}|` +
    data.map(entry => 
      `269=${entry.type}|270=${entry.price}|271=${entry.size}|299=${entry.entryId}|`
    ).join('')
  );
  
  clients.forEach(client => {
    if (client.readyState === client.OPEN) {
      client.send(fixMessage.replace(/\|/g, '\x01'));
    }
  });
}